# Version 2.11 - 2.12

## Product attributes in filters

When using the products component to get filters for a listing, the product attributes can be contained as part of the filters. The querying and formatting of the product attributes was significantly slower than the similar query for product options. The functionality of containing the product attributes has changed slightly and therefore would break any filters that provide custom query parameters for the product attributes/groups. The product attribute groups are now queried for and cached separately from the product attributes so the following changes need to be made.

1) Any query parameters passed through to the `getOptionFiltersForListing()` intended to modify which product attribute groups are returned now need to be passed through in the `$extraParams` method parameter under the key of `ProductAttributeGroup`, the alias of the ProductAttributeGroup model.
2) As the product attribute groups are now cached when the filters are retrieved. Custom functionality that creates/modified/deletes product attribute groups that doesn't go through the `afterSave()` callback will need to clear the cache otherwise the filters will not get updated.
3) A Variant join has been added to the product attribute query so that the products returned have at least one available variant. This will cause issues with custom query parameters if the join alias is the same as Variant. If a variant join is being passed through as a custom query parameter then it will need to have it's alias changed.
